/**
 * 
 */
package it.infocamere.wscu.clientws.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import it.infocamere.webtelemaco.wscu.servicepraticheri.ComunicazionePraticheRI;
import it.infocamere.webtelemaco.wscu.servicepraticheri.ComunicazionePraticheRIPortType;
import it.infocamere.webtelemaco.wscu.servicepraticheri.PraticaRequestType;
import it.infocamere.webtelemaco.wscu.servicepraticheri.PraticaResponseType;
import it.infocamere.webtelemaco.wscu.servicepraticheri.PraticheRIWsFault;

/**
 * @author yyi2047
 *
 */
public class ComunicazionePraticaRIWsClient {

	private static final int TIMEOUT = 300000;
	private static final String CHIAVE_CODIFICA_SHA1 = "DECIMAL";
	private static final String ALGORITMO_FIRMA = "SHA1";

	private ComunicazionePraticheRIPortType port;
	private String user;
	private String passwd;
	private String tokenAutorizzativo;
	private OutputStream trackingOutputStream;
	
	private static class AuthenticationInjectHandler implements SOAPHandler<SOAPMessageContext>{

		private static final String NAME_SPACE_COOKIE = "http://webtelemaco.infocamere.it/wscu/service/";

		private final ComunicazionePraticaRIWsClient client;

		public AuthenticationInjectHandler(ComunicazionePraticaRIWsClient client) {
			this.client = client;
		}

		@Override
		public boolean handleMessage(SOAPMessageContext context) {
		    Boolean isOutBound = (Boolean) context.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);

		    SOAPMessage soapMsg = context.getMessage();

		    //if this is a request, true for outbound messages, false for inbound
		    if (!isOutBound) {
		    	//tracking
		    	//tracking
		        trackSoapMessage(soapMsg, "------- RESPONSE -------");
		    	return true; //continue other handler chain
		    }

		    try {
		        SOAPEnvelope soapEnv = soapMsg.getSOAPPart().getEnvelope();
		        SOAPHeader soapHeader = soapEnv.getHeader();
		                
		        //if no header, add one
		        if (soapHeader == null){
		          	soapHeader = soapEnv.addHeader();
		        }
		        //add a soap header
		        QName cookie = new QName(NAME_SPACE_COOKIE, "Cookie");
		        SOAPHeaderElement cookieHeaderElement = soapHeader.addHeaderElement(cookie);
		        if (client.user!=null && client.passwd!=null) {
		        	QName cookieUserPwd = new QName(NAME_SPACE_COOKIE, "cookieUserPwd");
		        	SOAPElement cookieUserPwdElement = cookieHeaderElement.addChildElement(cookieUserPwd);
		        	QName cookieUser = new QName(NAME_SPACE_COOKIE, "user");
		        	SOAPElement userElement = cookieUserPwdElement.addChildElement(cookieUser);
		        	userElement.addTextNode(client.user);
		        	QName cookiePwd = new QName(NAME_SPACE_COOKIE, "pwd");
		        	SOAPElement pwdElement = cookieUserPwdElement.addChildElement(cookiePwd);
		        	pwdElement.addTextNode(client.passwd);

		        } else if (client.tokenAutorizzativo!=null) {
		        	QName cookieToken = new QName(NAME_SPACE_COOKIE, "cookieToken");
		        	SOAPElement cookieTokenElement = cookieHeaderElement.addChildElement(cookieToken);
		        	cookieTokenElement.addTextNode(client.tokenAutorizzativo);
		        }

		        soapMsg.saveChanges();

		        //tracking
		        trackSoapMessage(soapMsg, "------- REQUEST -------");

		    } catch(SOAPException e) {
		    }

		    //continue other handler chain
		    return true;
		}

		private void trackSoapMessage(SOAPMessage soapMsg, String headerLine) {
			try {
				if (client.trackingOutputStream!=null) {
					client.trackingOutputStream.write(headerLine.getBytes());
					client.trackingOutputStream.write('\n');
		        	soapMsg.writeTo(client.trackingOutputStream);
		        	client.trackingOutputStream.write('\n');
		        	
				}
			} catch(SOAPException | IOException e) {
		    }
		}

		@Override
		public boolean handleFault(SOAPMessageContext context) {
			SOAPMessage soapMsg = context.getMessage();
			trackSoapMessage(soapMsg, "------- FAULT RESPONSE -------");
		    return true;
		}

		@Override
		public void close(MessageContext context) {
		    //System.out.println("Client : close()......");
		}

		@Override
		public Set<QName> getHeaders() {
		     //System.out.println("Client : getHeaders()......");
		    return null;
		}
	}

	public ComunicazionePraticaRIWsClient(URL endpoint) {
		this(endpoint, null);
	}

	public ComunicazionePraticaRIWsClient(URL endpoint, OutputStream trackingOutputStream) {
		getWSPort(endpoint, TIMEOUT);
		this.trackingOutputStream = trackingOutputStream;
	}

	public void setTokenAutorizzativo(String tokenAutorizzativo) {
		this.tokenAutorizzativo = tokenAutorizzativo;
	}
	
	public void setUserPasswd(String user, String passwd) {
		this.user = user;
		this.passwd = passwd;
	}

	private void getWSPort(URL endpoint, int timeout) {
		ComunicazionePraticheRI service = new ComunicazionePraticheRI();
		port = service.getComunicazionePraticheRISOAP12PortHttp();
		
		//Basic Authentication SOAP
		BindingProvider prov = (BindingProvider)port;
		Map<String, Object> rc = prov.getRequestContext();
		//rc.put(BindingProvider.USERNAME_PROPERTY, basicAuthUsername);
		//rc.put(BindingProvider.PASSWORD_PROPERTY, basicAuthPassword);
		rc.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, endpoint.toString());

		if (timeout != 0) {
			rc.put("com.sun.xml.internal.ws.connect.timeout", timeout);
			rc.put("com.sun.xml.internal.ws.request.timeout", timeout);

			rc.put("com.sun.xml.ws.connect.timeout", timeout);
			rc.put("com.sun.xml.ws.request.timeout", timeout);

			rc.put("javax.xml.ws.client.connectionTimeout", timeout);
			rc.put("javax.xml.ws.client.receiveTimeout", timeout);

			rc.put("org.jboss.ws.timeout", timeout);  
		}

		prov.getBinding().setHandlerChain(Collections.singletonList(
				new AuthenticationInjectHandler(this)));
	}

	private byte[] ritornaFirmaFile(InputStream str) throws Exception {
		return SignatureManager.getInstance().getSignature(str, ALGORITMO_FIRMA);
	}

	private PraticaRequestType toPraticaRequest(Path presentazione, Path pratica,
			String praticaSha1Sign) throws Exception {
		FileDataSource dsPresentazione = new FileDataSource(presentazione.toString());
    	DataHandler dhPresentazione = new DataHandler(dsPresentazione);
    	FileDataSource dsPratica = new FileDataSource(pratica.toString());
    	DataHandler dhPratica = new DataHandler(dsPratica);

    	PraticaRequestType praticaRequest = new PraticaRequestType();
    	praticaRequest.setPresentazione(dhPresentazione);
    	praticaRequest.setPratica(dhPratica);
    	
    	InputStream strIn = dsPratica.getInputStream();
    	if (praticaSha1Sign==null) {
    		praticaSha1Sign = CoderEncoder.getInstance()
    			.encode(ritornaFirmaFile(strIn), CHIAVE_CODIFICA_SHA1);
    	}
    	praticaRequest.setPraticaSha1Sign(praticaSha1Sign);

    	return praticaRequest;
	}

    public String inviaPratica(Path presentazione, Path pratica) throws Exception {
    	return inviaPratica(presentazione, pratica, null);
    }

    public String inviaPratica(Path presentazione, Path pratica, String praticaSha1Sign) throws Exception {
    	PraticaRequestType praticaRequest = toPraticaRequest(presentazione, pratica, praticaSha1Sign);

    	return port.inviaPratica(praticaRequest);
    }

    public String controllaPratica(Path presentazione, Path pratica) throws Exception {
    	return controllaPratica(presentazione, pratica, null);
    }

    public String controllaPratica(Path presentazione, Path pratica, String praticaSha1Sign) throws Exception {
    	PraticaRequestType praticaRequest = toPraticaRequest(presentazione, pratica, praticaSha1Sign);

    	return port.controllaPratica(praticaRequest);
    }

    public String getEsito(String praticaId, Path outPath) throws IOException, PraticheRIWsFault {
    	PraticaResponseType prt = port.getEsito(praticaId);
    	StringBuffer buff = new StringBuffer();
    	OutputStream out = null;
    	if (outPath!=null) {
    		out = Files.newOutputStream(outPath);
    	}
    	byte[] b = new byte[2048];
		InputStream is = new ByteArrayInputStream(prt.getEsito());	
		int len = 0;
		while (len >= 0) {
			len = is.read(b);
			if (len > 0) {
				buff.append(new String(b, 0, len, StandardCharsets.UTF_8));
				if (out!=null) {
					out.write(b,0,len);
				}
			}
		}

		if (out!=null) {
			out.close();
		}
		return buff.toString();
    }
}
