package it.infocamere.wscu.clientws.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import it.infocamere.webtelemaco.wscu.servicepraticheri.PraticheRIWsFault;
import it.infocamere.wscu.clientws.net.URIS_WS;

/**
 * La classe che consuma i web service di autenticazione e di comunicazione
 * unica.
 */
public class ServiziComunicazionePraticheRIWs {

	private final static String TMP = ".tmp";
	public static final String INVIO = "invio";
	public static final String CONTROLLO = "controllo";
	public static final String ESITO = "esito";
	private static final String CHIAVE_CODIFICA_SHA1 = "DECIMAL";
	private static final String ALGORITMO_FIRMA = "SHA1";
	// file temporaneo di appoggio su disco
	//private File filePratica = null;
	//private File filePresentazione = null;

	private String AUTHENTICATION;
	//private static final String AUTHENTICATION_MINOSSE = "minosse";
	//private static final String AUTHENTICATION_WSCU = "wscu";
	private static final String AUTHENTICATION_TOKEN = "token";
	private static final String AUTHENTICATION_EACA = "eaca";

	//private String connId; // token di autenticazione
	//private String secretKey; // token wscu con frase segreta di autenticazione
	private String secretToken; // token wscu con frase segreta di autenticazione
	private String user;
	private String pwd;

	private Log log = LogFactory.getLog(this.getClass());

	//private String providerName = null;

	protected URIS_WS uri = null;
	
	private OutputStream trackingOutputStream;
	
	public ServiziComunicazionePraticheRIWs(String user, String password) throws Exception {
		this(user, password, new URIS_WS());
	}
	
	/**
	 * 
	 * Il costruttore chiama il web service di autenticazione per ottenere un
	 * token valido. Il token verra' utilizzato ogni volta che si utilizza un
	 * servizio che consuma il web service di comunicazione unica.
	 * 
	 * @param user
	 * @param password
	 * @throws Exception
	 */
	public ServiziComunicazionePraticheRIWs(String user, String password, URIS_WS uri) throws Exception {
		this.uri = uri;
		/**
		if (password.indexOf("secretKey:") != -1) {
			AUTHENTICATION = AUTHENTICATION_WSCU;
			this.user = user;
			String strToken[] = password.split(":");
			secretKey = strToken[1];
		} else
		**/
		if (password.indexOf("secretToken:") != -1) {
			AUTHENTICATION = AUTHENTICATION_TOKEN;
			this.user = user;
			String strToken[] = password.split(":");
			secretToken = strToken[1];
		} else {
//			AUTHENTICATION = AUTHENTICATION_MINOSSE;
//			connId = AutenticazioneUtil.login(user, password, uri);
			AUTHENTICATION = AUTHENTICATION_EACA;
			this.user = user;
			this.pwd = password;
		}
	}

	public ServiziComunicazionePraticheRIWs(String user, String password, URIS_WS uri, boolean eaca) throws Exception {
		this.uri = uri;
		AUTHENTICATION = AUTHENTICATION_EACA;
		this.user = user;
		this.pwd = password;
	}

	public void setTrackingOutputStream(OutputStream trackingOutputStream) {
		this.trackingOutputStream = trackingOutputStream;
	}

	public void close() throws Exception {
		System.out.println("_praticaWSClient - Logout " + AUTHENTICATION);
		/**
		if (AUTHENTICATION.equals(AUTHENTICATION_MINOSSE)) {
			try {
				AutenticazioneUtil.logout(connId, uri);
			} catch (Exception e) {
				System.out.println("Si e' verificato un problema nel logout");
			}
		}
		**/
	}

	/**
	 * Spedisce la pratica
	 * 
	 * @param nomeFilePratica
	 * @param nomeFilePresentazione
	 * @return l'id assegnato alla pratica
	 * @throws Exception
	 */
	public String spedisciPratica(String nomeFilePratica, String nomeFilePresentazione,
			String praticaSha1Sign) throws Exception {
		return invia(INVIO, nomeFilePratica, nomeFilePresentazione, praticaSha1Sign);
	}

	public String spedisciPratica(String nomeFilePratica, String nomeFilePresentazione) throws Exception {
		return spedisciPratica(nomeFilePratica, nomeFilePresentazione, null);
	}

	/**
	 * Spedisce la pratica per eseguire la sola verifica
	 * 
	 * @param nomeFilePratica
	 * @param nomeFilePresentazione
	 * @return l'id assegnato alla pratica
	 * @throws Exception
	 */
	public String controllaPratica(String nomeFilePratica, String nomeFilePresentazione,
			String praticaSha1Sign) throws Exception {
		return invia(CONTROLLO, nomeFilePratica, nomeFilePresentazione, praticaSha1Sign);
	}
	
	public String controllaPratica(String nomeFilePratica, String nomeFilePresentazione) throws Exception {
		return controllaPratica(nomeFilePratica, nomeFilePresentazione, null);
	}

	/**
	 * 
	 * @param id
	 *            l'id della pratica
	 * @return l'esito della varifica (in formato xml)
	 * @throws Exception
	 */
	public String esitoPratica(String id) throws IOException, PraticheRIWsFault {
		return esitoPratica(id, null);

		/**
		log.info("verifica esito - INIZIO ");
		ComunicazioneUnicaBean bean = new ComunicazioneUnicaBean();
		bean.setIdRichiesta(id);
		return _praticaWSClient(bean, ESITO, null);
		**/
	}

	/**
	 * 
	 * @param id
	 * @param file
	 * @return
	 * @throws PraticheRIWsFault 
	 * @throws Exception
	 */
	public String esitoPratica(String id, File fileOut) throws IOException, PraticheRIWsFault {
		log.info("verifica esito - INIZIO ");
		URL endPointUrl = new URL(getComunicaEndPoint());
		ComunicazionePraticaRIWsClient c = new ComunicazionePraticaRIWsClient(endPointUrl);
		setAutenticationData(c);
	
		String ret = c.getEsito(id, fileOut==null?null:fileOut.toPath());
		return ret;
	}

	private String invia(String servizio, String nomeFilePratica,
			String nomeFilePresentazione, String praticaSha1Sign) throws Exception {
		URL endPointUrl = new URL(getComunicaEndPoint());
		ComunicazionePraticaRIWsClient c = new ComunicazionePraticaRIWsClient(endPointUrl,
				trackingOutputStream);
		setAutenticationData(c);

		Path presentazioneFile = Paths.get(nomeFilePresentazione);
		Path pratica = Paths.get(nomeFilePratica);
		String praticaId;
		if (INVIO.equals(servizio)) {
			praticaId = c.inviaPratica(presentazioneFile, pratica, praticaSha1Sign);
		} else {
			
			praticaId = c.controllaPratica(presentazioneFile, pratica, praticaSha1Sign);
		}

		return praticaId;
	}

	private void setAutenticationData(ComunicazionePraticaRIWsClient c) {
		if (AUTHENTICATION_TOKEN.equals(AUTHENTICATION)) {
			String cookieTokenStr = user
					+ "-"
					+ secretToken;
			c.setTokenAutorizzativo(cookieTokenStr);
		
		} else if (AUTHENTICATION_EACA.equals(AUTHENTICATION)) {
			c.setUserPasswd(user, pwd);
		}
	}

	/**
	private String invia(String servizio, String nomeFilePratica, String nomeFilePresentazione) throws Exception {
		log.info("spedizione - INIZIO ");
		ComunicazioneUnicaBean bean = new ComunicazioneUnicaBean();

		File file = new File(nomeFilePresentazione);
		FormFile filePresentazione = new DiskFile(nomeFilePresentazione);
		filePresentazione.setFileName(ritornaFileDirectory(nomeFilePresentazione));
		filePresentazione.setContentType("text/xml");
		filePresentazione.setFileSize((int) file.length());
		bean.setFilePresentazione(filePresentazione);

		FormFile fileZip = new DiskFile(nomeFilePratica);
		file = new File(nomeFilePratica);
		fileZip.setFileName(ritornaFileDirectory(nomeFilePratica));
		fileZip.setContentType("application/zip");
		fileZip.setFileSize((int) file.length());
		bean.setFilePratica(fileZip);
		return _praticaWSClient(bean, servizio, null);
	}
	**/

	/**
	 * 
	 * Prepara i parametri e chiama il web service di comunicazione unica.
	 * 
	 * @param bean
	 * @param operation
	 * @return
	 * @throws Exception
	 */
	/**
	private String _praticaWSClient(ComunicazioneUnicaBean bean, String operation, File fileOut) throws Exception {
		log.info("_praticaWSClient - INIZIO. operazione: " + operation);
		// output stream per salvataggio temporaneo attachment ricevuto
		FileOutputStream strOut = null;
		String firma = null;
		// usato per leggere il flusso di ingresso dal DataHandler nel calcolo
		// SHA1
		InputStream strIn = null;
		String fileNamePratica = "";
		String fileNamePresentazione = "";

		ComunicazionePraticheRIStub service = new ComunicazionePraticheRIStub();
		service._getServiceClient().getOptions().setProperty(Constants.Configuration.ENABLE_MTOM, Constants.VALUE_TRUE);
		service._getServiceClient().getOptions().setManageSession(true);
		service._getServiceClient().getOptions().setTimeOutInMilliSeconds(300000);
		service._getServiceClient().setTargetEPR(new EndpointReference(getComunicaEndPoint()));
		log.info("_praticaWSClient - Target EPR: " + service._getServiceClient().getTargetEPR().toString());
		// ----------------------------------------
		// COSTRUISCE OGGETTO PER INVIO O CONTROLLO
		// ----------------------------------------
		PraticaRequest praticaRq = new PraticaRequest();
		Cookie cookie = new Cookie();
		if (!ESITO.equals(operation)) {
			DataHandler dataHandlerPresentazione = null;
			FileDataSource dataSourcePresentazione = null;
			DataHandler dataHandlerPratica = null;
			FileDataSource dataSourcePratica = null;
			PraticaRequestType praticaType = new PraticaRequestType();
			Base64Binary praticaBase64 = new Base64Binary();
			Base64Binary presentazioneBase64 = new Base64Binary();
			fileNamePratica = bean.getFilePratica().getFileName() + TMP;
			fileNamePresentazione = bean.getFilePresentazione().getFileName() + TMP;
			log.info("_praticaWSClient - Preparo files: Presentazione: " + fileNamePresentazione + " Pratica: " + fileNamePratica);
			filePratica = new File(fileNamePratica);
			try {
				strOut = new FileOutputStream(fileNamePratica);
				strOut.write(bean.getFilePratica().getFileData());
				strOut.flush();
				strOut.close();
				filePresentazione = new File(fileNamePresentazione);
				strOut = new FileOutputStream(filePresentazione);
				strOut.write(bean.getFilePresentazione().getFileData());
				strOut.flush();
				strOut.close();
				dataSourcePresentazione = new FileDataSource(fileNamePresentazione);
				dataHandlerPresentazione = new DataHandler(dataSourcePresentazione);
				dataSourcePratica = new FileDataSource(fileNamePratica);
				dataHandlerPratica = new DataHandler(dataSourcePratica);
				strIn = dataSourcePratica.getInputStream();
			} catch (IOException e) {
				e.printStackTrace();
				throw new Exception("_praticaWSClient - errore interno del client nella gestione degli input Stream: " + e.getLocalizedMessage());
			}
			praticaBase64.setBase64Binary(dataHandlerPratica);
			presentazioneBase64.setBase64Binary(dataHandlerPresentazione);
			praticaType.setPratica(praticaBase64);
			praticaType.setPresentazione(presentazioneBase64);

			firma = CoderEncoder.getInstance().encode(ritornaFirmaFile(bean.getLocale(), strIn), CHIAVE_CODIFICA_SHA1, bean.getLocale());
			praticaType.setPraticaSha1Sign(firma);
			praticaRq.setPraticaRequest(praticaType);
		} else {
			firma = bean.getIdRichiesta();
		}
		CookieTypeChoice_type0 choice = new CookieTypeChoice_type0();
		**//**
		if (AUTHENTICATION_MINOSSE.equals(AUTHENTICATION)) {
			choice.setCookieMinosse(connId);

		} else
		**//**
		if (AUTHENTICATION_TOKEN.equals(AUTHENTICATION)) {
			String cookieTokenStr = user
					+ "-"
					+ secretToken;

			choice.setCookieToken(cookieTokenStr);

		**//**
		} else if (AUTHENTICATION_WSCU.equals(AUTHENTICATION)) {
			String cookieWscuStr = user
					+ "-"
					+ CoderEncoder.getInstance().encode(SignatureManager.getInstance().getSignatureWithPassword(bean.getLocale(), firma.getBytes(), ALGORITMO_FIRMA, secretKey), CHIAVE_CODIFICA_SHA1,
							bean.getLocale());

			choice.setCookieWscu(cookieWscuStr);
		**//**
		
		} else if (AUTHENTICATION_EACA.equals(AUTHENTICATION)) {
			UserPwdType userPwd = new UserPwdType();
			userPwd.setUser(user);
			userPwd.setPwd(pwd);
			choice.setCookieUserPwd(userPwd);
		}

		CookieType cookieType = new CookieType();
		cookieType.setCookieTypeChoice_type0(choice);
		cookie.setCookie(cookieType);

		String risultato = null;
		try {
			if (INVIO.equals(operation)) {
				PraticaID resp = service.inviaPratica(praticaRq, cookie);
				risultato = resp.getPraticaID();
			}
			if (CONTROLLO.equals(operation)) {
				PraticaID resp = service.controllaPratica(praticaRq, cookie);
				risultato = resp.getPraticaID();
			}
			if (ESITO.equals(operation)) {
				FileOutputStream out=null;
				PraticaID praticaID = new PraticaID();
				praticaID.setPraticaID(bean.getIdRichiesta());
				PraticaResponse resp = service.getEsito(praticaID, cookie);
				byte[] b = new byte[32716];
				StringBuffer buff = new StringBuffer();
				try {
					InputStream is = resp.getPraticaResponse().getEsito().getBase64Binary().getInputStream();	
					if (fileOut!=null){
						out=new FileOutputStream(fileOut);
					}
					int len = 0;
					while (len >= 0) {
						len = is.read(b);
						if (len > 0) {
							try {
								buff.append(new String(b, 0, len, "UTF-8"));
								if (out!=null){
									out.write(b,0,len);
								}
							} catch (UnsupportedEncodingException e) {
								e.printStackTrace();
								log.error("_praticaWSClient - UnsupportedEncodingException: " + e.getLocalizedMessage());
							}
						}
					}
				} catch (IOException e) {
					e.printStackTrace();
					log.error("_praticaWSClient - Errore copia file ricevuto: IOException " + e.getLocalizedMessage());
				}
				if (out!=null){
					out.flush();
					out.close();
				}
				risultato = buff.toString();
			}
		} catch (RemoteException e) {
			throw new Exception(e.getMessage(), e);
		} finally {
			if (strOut != null)
				try {
					strOut.close();
				} catch (IOException e) {
					log.error("_praticaWSClient - Errore chiusura Output stream file: " + fileNamePratica + " - " + fileNamePresentazione);
				}
			if (strIn != null)
				try {
					strIn.close();
				} catch (IOException e) {
					e.printStackTrace();
					log.error("_praticaWSClient - Errore chiusura Input stream file: " + fileNamePratica + " - " + fileNamePresentazione);
				}
			if (!ESITO.equals(operation)) {
				*//*
				 * la cancellazione non andr� a buonfine nel caso di ssl3
				 * business key perch� la dll della chiavetta fa un lock sui
				 * file quindi la evito in quel caso e la faccio nel main
				 *//*
				if (this.providerName == null)
					this.cancellaFileTemporanei();
			}
		}
		return risultato;
	}
	**/

	/**
	public void cancellaFileTemporanei() {
		int i = 0;
		int MAX_ITER = 10;
		boolean filePraticaDeleted = false;
		boolean filePresentazioneDeleted = false;
		try {
			if (filePratica != null && filePratica.exists()) {
				while (filePratica != null && i < MAX_ITER && !filePraticaDeleted) {
					if (filePratica.delete()) {
						filePraticaDeleted = true;
					}
					i++;
					Thread.sleep(50);
				}

				if (!filePraticaDeleted) {
					log.error("_praticaWSClient - Non � stato possibile cancellare il file: " + filePratica.getAbsolutePath());
				}
			}
			if (filePresentazione != null && filePresentazione.exists()) {
				i = 0;
				while (filePresentazione != null && i < MAX_ITER && !filePresentazioneDeleted) {
					if (filePresentazione.delete()) {
						filePresentazioneDeleted = true;
					}
					i++;
					Thread.sleep(50);
				}
				if (!filePresentazioneDeleted) {
					log.error("_praticaWSClient - Non � stato possibile cancellare il file: " + filePresentazione.getAbsolutePath());
				}
			}
		} catch (InterruptedException ex) {
		}
	}
	**/

	protected String getComunicaEndPoint() {
		return uri.WS_COM_PRATICA_RI;
	}

	private byte[] ritornaFirmaFile(Locale locale, InputStream str) throws Exception {
		return SignatureManager.getInstance().getSignature(str, ALGORITMO_FIRMA);
	}

	protected static String ritornaFileDirectory(String fullName) {
		if (fullName.lastIndexOf("/") < 0 && fullName.lastIndexOf("\\") < 0)
			return fullName;
		else if (fullName.lastIndexOf("/") >= 0)
			return fullName.substring(fullName.lastIndexOf("/") + 1, fullName.length());
		else
			return fullName.substring(fullName.lastIndexOf("/") + 1, fullName.length());
	}

	/**
	 * @param providerName
	 *            the providerName to set
	 */
	/**
	protected void setProviderName(String providerName) {
		this.providerName = providerName;
	}
	**/

	/**
	 * @return the providerName
	 */
	/**
	public String getProviderName() {
		return providerName;
	}
	**/
}