package it.infocamere.wscu.clientws.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;

import org.apache.log4j.Logger;

/**
 * Metodi di gestione della firma dei file. Consente la firma con MD5 o SHA-1
 * @author yye0464
 *
 */
public class SignatureManager {
	
	private Logger log = Logger.getLogger(getClass());
	
	private static SignatureManager single;
	
	/**
	 * Ritorna l'istanza (Singleton) della classe
	 * @return
	 */
	public static SignatureManager getInstance(){
		if (single == null) single = new SignatureManager();
		return single;
	}
	
	/**
	 * Costruttore di default
	 */
	private SignatureManager(){
	}
	
	/**
	 * Verifica la firma passata come argomento con quella ottenuta dall'inputStream.
	 * @param locale
	 * @param str
	 * @param type
	 * @param signature
	 * @throws FatalException
	 * @throws InputException
	 */
	public void verifySignature(InputStream str, String type, byte[] signature) throws Exception{
		if (signature == null)
			throw new Exception("eccezione.fnv.firmaNull");
		byte[] toVerify = getSignature(str, type);
		if (!MessageDigest.isEqual(signature, toVerify))
			throw new Exception("eccezione.fnv.firmaNonCorrisponde");
	}
	
	/**
	 * Verifica la firma passata come argomento con quella ottenuta dalla stringa ingresso con la concatenazione della password dell'utente.
	 * @param locale
	 * @param str
	 * @param type
	 * @param signature
	 * @param password
	 * @throws FatalException
	 * @throws InputException
	 */
	public void verifySignatureWithPassword(Locale locale, byte[] ingresso, String type, byte[] signature, String password) throws Exception {
		if (signature == null)
			throw new Exception("eccezione.fnv.firmaNull");
		if (ingresso == null)
			throw new Exception("eccezione.fnv.campoFirmaNull");
		byte[] toVerify = getSignatureWithPassword(locale, ingresso, type, password);
		if (!MessageDigest.isEqual(signature, toVerify))
			throw new Exception("eccezione.fnv.firmaNonCorrisponde");
	}

	/**
	 * Ritorna la firma dell'inputStream
	 * @param locale
	 * @param str
	 * @param type
	 * @return
	 * @throws FatalException
	 */
	public byte[] getSignature(InputStream str, String type) throws Exception{
		try {
			MessageDigest dig = MessageDigest.getInstance(type);
			byte byteFromInputStr[]=new byte[32768];
			while (str.available()>0){
		        int len = str.read(byteFromInputStr);
		        dig.update(byteFromInputStr, 0, len);
		    }
			return dig.digest();
		} catch (IOException e) {
			log.warn("Eccezione I/O: " + e.getMessage());
			throw new Exception("eccezione.Fatal.erroreInterno");
		} catch (NoSuchAlgorithmException e) {
			log.warn("Eccezione NoSuchAlgorithmException" + e.getMessage());
			throw new Exception("eccezione.Fatal.erroreInterno");
		} catch (Exception e) {
			log.warn("Eccezione Exception" + e.getMessage());
			throw new Exception("eccezione.Fatal.erroreInterno");
		}
	}
	
	/**
	 * Ritorna la firma della stringa ingresso concatenata con la password dell'utente in chiaro
	 * @param locale
	 * @param ingresso
	 * @param type
	 * @param password
	 * @return
	 * @throws FatalException
	 * @throws InputException
	 */
	public byte[] getSignatureWithPassword(Locale locale, byte[] ingresso, String type, String password) throws Exception{
		try {
			/*SecretUtil scr = new SecretUtil();
			password = scr.decrypt(password);*/
			MessageDigest dig = MessageDigest.getInstance(type);
	        dig.update(ingresso);
			dig.update(password.getBytes());
			return dig.digest();
		/*} catch (IOException e) {
			log.warn("Eccezione I/O", e);
			throw new FatalException(Util.getInstance().getLocalMessage(locale, "eccezione.Fatal.erroreInterno"), e);*/
		} catch (NoSuchAlgorithmException e) {
			log.warn("Eccezione NoSuchAlgorithmException "  + e.getMessage());
			throw new Exception("eccezione.Fatal.erroreInterno");
		} catch (Exception e) {
			log.warn("Eccezione Exception " + e.getMessage());
			throw new Exception("eccezione.Fatal.erroreInterno");
		}
	}
}